#!/bin/bash
path="/path/to/youtube"

sudo chown -R user:user "${path}"

yt-dlp --config-location "ytdlp-config.txt" -a "${path}/channels-1.txt"

echo
echo "Deleting JSON files"
echo
for file in "${path}"/*/*.json; do
  if [ -f "$file" ]; then
    sudo rm "$file"
  fi
done

echo "Done"
echo

sudo chown -R jellyfin:jellyfin "${path}"



# ytdlp-config.txt
--progress
--ignore-errors
--check-formats
--format "bestvideo[height<=1080][ext=mkv]+bestaudio[ext=m4a]/best[ext=mkv]/best"
--merge-output mkv
--write-info-json
--write-annotations
--write-thumbnail
--convert-thumbnails jpg
--embed-thumbnail
--embed-chapters
--embed-info-json
--ignore-errors
--add-metadata
--restrict-filenames
--concurrent-fragments 3
--sponsorblock-mark all,-preview,-filler,-interaction
--dateafter now-7days
--playlist-end 10
--no-playlist
--cookies-from-browser firefox:vzh1hdbr.default-release
--compat-options no-youtube-unavailable-videos
--match-filter "!is_live & live_status!=is_upcoming & availability=public & title!*=WAN"
--download-archive "/path/to/youtube/downloaded.txt"
-o "/path/to/youtube/%(channel)s/%(upload_date>%Y-%m-%d)s - %(title)s [%(id)s].%(ext)s"