#!/bin/bash
path="/path/to/youtube-folder"

sudo chown -R user:user "${path}"

yt-dlp --config-location "ytdlp-config.txt" -a "${path}/channels.txt"

echo
echo "Deleting JSON files"
echo
for file in "${path}"/*/*.json; do
  if [ -f "$file" ]; then
    sudo rm "$file"
  fi
done

echo "Done"
echo

# Making it possible for you to delete files directly from Jellyfin
sudo chown -R jellyfin:jellyfin "${path}"



# ytdlp-config.txt
--progress
--ignore-errors
--check-formats
--format "bestvideo[height<=1080][ext=mkv]+bestaudio[ext=m4a]/best[ext=mkv]/best"
--merge-output mkv
--write-info-json
--write-annotations
--write-thumbnail
--convert-thumbnails jpg
--embed-thumbnail
--embed-chapters
--embed-info-json
--ignore-errors
--add-metadata
--restrict-filenames
--concurrent-fragments 3
--sponsorblock-mark all,-preview,-filler,-interaction
--dateafter now-7days
--playlist-end 10
--no-playlist
--cookies-from-browser firefox:vzh1hdbr.default-release
--compat-options no-youtube-unavailable-videos
--match-filter "!is_live & live_status!=is_upcoming & availability=public & title!*=WAN"
--download-archive "/path/to/youtube/downloaded.txt"
-o "/path/to/youtube/%(channel)s/%(upload_date>%Y-%m-%d)s - %(title)s [%(id)s].%(ext)s"


# channels.txt
#https://piped.video/channel/UCRiYVwfoEnKfweISfKytuQw    # Akimbo
https://piped.video/channel/UCxXlxVmarXu3n340ah5xwqA    # Astrobiscuit
https://piped.video/channel/UC-9b7aDP6ZN0coj9-xFnrtw    # Astrum
#https://piped.video/channel/UCTEEa35OCDcJDh-lwbXehdg    # CantrellCaving
#https://piped.video/channel/UCbW17b5g1Eb90M457eOykPg    # Chinese cuisine
https://piped.video/channel/UCg6gPGh8HU2U01vaFCAsvmQ    # Chris Titus Tech
#https://piped.video/channel/UCvfqpaehdaqtkXPNhvJRyGA    # Dash Cam Owners Australia
https://piped.video/channel/UCdC0An4ZPNr_YiFiYoVbwaw    # Daily Dose of Internet
https://piped.video/channel/UCTIa8uo_aisNdqQpMf4wKTg    # DailyDoseOfInternetCats
#https://piped.video/channel/UCnetiRHPnIMBCm-yY4m69qA    # Dashcam Lessons
#https://piped.video/channel/UCOS7jdle9zw_HnKW4ytZnDw    # Dashcam Nation
#https://piped.video/channel/UCqOoboPm3uhY_YXhvhmL-WA    # Discovery
https://piped.video/channel/UCxByVUuLdxxiqQVmbOnDEzw    # Erik Granqvist
#https://piped.video/channel/UCPq2ETz4aAGo2Z-8JisDPIA    # ESL Counter-Strike
https://piped.video/channel/UCwF3VyalTHzL0L-GDlwtbRw    # EVE Online
#https://piped.video/channel/UC73dVtWf9mpjiWYkXyIlm7A    # Exploring the Unbeaten Path
https://piped.video/channel/UCPDis9pjXuqyI7RYLJ-TTSA    # FailArmy
https://piped.video/channel/UCt8CdzMEoTie3iix3KmvV7A    # GameSprout
#https://piped.video/channel/UC5SlWFFu-YvbujLKa0zoNGw    # Idiot Drivers
#https://piped.video/channel/UCXE0IwEN5HkDohBq2ebv5Bw    # Idiots In Cars
https://piped.video/channel/UCw7FkXsC00lH2v2yB5LQoYA    # jackfrags
https://piped.video/channel/UCWFKCr40YwOZQx8FHU_ZqqQ    # JerryRigEverything
https://piped.video/channel/UCla1P6TzCetvMHJ6ZHyXxgA    # Kanal 5 Sverige
https://piped.video/channel/UCsXVk37bltHxD1rDPwtNM8Q    # Kurzgesagt - In a Nutshell
#https://piped.video/channel/UCpJmBQ8iNHXeQ7jQWDyGe3A    # Life Noggin
https://piped.video/channel/UCXuqSBlHAE6Xw-yeJA0Tunw    # Linus Tech Tips
https://piped.video/channel/UCS1-E3fjfJmY5O2HqhXM5CQ    # Learn Japanese Channel
#https://piped.video/channel/UCKIrZr7WuPFgFy7OfkAuHOw    # MegaDrivingSchool
#https://piped.video/channel/UCS67mNnpfnHsU3IQYNHLToA    # Most Dangerous
#https://piped.video/channel/UCpVm7bg6pXKo1Pr6k5kxG9A    # National Geographic
#https://piped.video/channel/UCDPk9MG2RexnOMGTD-YnSnA    # Nat Geo Wild
#https://piped.video/channel/UCL-g3eGJi1omSDSz48AML-g    # NVIDIA GeForce
https://piped.video/channel/UC-ihxmkocezGSm9JcKg1rfw    # OperatorDrewski
https://piped.video/channel/UCfpCQ89W9wjkHc8J_6eTbBg    # Outdoor Boys
#https://piped.video/channel/UCKGe7fZ_S788Jaspxg-_5Sg    # PC Security Channel
https://piped.video/channel/UCwdsaWtA70AiVeALp2ux6RA    # RamenStyle
#https://piped.video/channel/UCs5QhJQF9I1m81bCJy0WO-w    # Real History
#https://piped.video/channel/UCB1qBlpuLMi2ydz8zxFfLfw    # Ribecka
https://piped.video/channel/UC8kQrh-1JyFZ3RiTHHKMt7A    # Ruby Dashcam Academy
https://piped.video/channel/UCRtsZ5Iak9wSLsQLQ3XOAeA    # SciManDan
#https://piped.video/channel/UCZpZTSdvEgVf0BqTqf9NjNg    # Sean Dalton
https://piped.video/channel/UCpXwMqnXfJzazKS5fJ8nrVw    # shiey
#https://piped.video/channel/UCUMwsAsbK-SsW5GHufJJFUA    # SHL
https://piped.video/channel/UCpB959t8iPrxQWj7G6n0ctQ    # SSSniperWolf
https://piped.video/channel/UCQD3awTLw9i8Xzh85FKsuJA    # SovietWomble
#https://piped.video/channel/UCOt5hVyS2-nbcJ3_FP41Ajg    # Tomographic
#https://piped.video/channel/UCHnyfMqiRRG1u-2MsSQLbXA    # Veritasium
https://piped.video/channel/UCYfnmhHA2O-q1JHPJDWpaOQ    # Volvo Dashcam
#https://piped.video/channel/UCvz84_Q0BbvZThy75mbd-Dg    # Zack D. Films
https://piped.video/channel/UC4Tklxku1yPcRIH0VVCKoeA    # Quantum Tech HD