#!/bin/bash
path="/path/to/youtube"

sudo chown -R airikr:airikr "${path}"

yt-dlp \
--progress \
--ignore-errors \
--check-formats \
--format "bv*[height<1080][ext=mp4]+ba" \
--cookies-from-browser firefox:av9irb5a.profile \
--merge-output mkv \
--write-info-json \
--write-annotations \
--write-thumbnail \
--convert-thumbnails jpg \
--embed-thumbnail \
--embed-chapters \
--embed-info-json \
--ignore-errors \
--add-metadata \
--parse-metadata "%(title)s:%(meta_title)s" \
--parse-metadata "%(uploader)s:%(meta_artist)s" \
--restrict-filenames \
--concurrent-fragments 3 \
--sponsorblock-mark all,-preview,-filler,-interaction \
--dateafter now-7days \
--playlist-end 10 \
--no-playlist \
--compat-options no-youtube-unavailable-videos \
--match-filter "!is_live & live_status!=is_upcoming & availability=public & title!*=WAN" \
--download-archive "${path}/downloaded.txt" \
-a "${path}/channels.txt" \
-o "${path}/%(channel)s/%(upload_date>%Y-%m-%d)s - %(title)s [%(id)s].%(ext)s"

sudo chown -R jellyfin:jellyfin "${path}"