#!/bin/bash
path="/path/to/youtube"

sudo chown -R airikr:airikr "${path}"

yt-dlp \
--check-formats \
--progress \
--ignore-errors \
--download-archive "${path}/downloaded.txt" \
--format "bv*[height<1080][ext=mp4]+ba" \
--cookies-from-browser firefox:av9irb5a.edgren \
--merge-output mkv \
--write-info-json \
--write-annotations \
--write-thumbnail \
--convert-thumbnails jpg \
--add-metadata \
--convert-thumbnail jpg \
--embed-thumbnail \
--embed-chapters \
--embed-info-json \
--restrict-filenames \
--concurrent-fragments 3 \
--sponsorblock-mark all,-preview,-filler,-interaction \
--dateafter now-7days \
--playlist-end 10 \
-a "${path}/channels.txt" \
-o "${path}/%(channel)s/%(upload_date>%Y-%m-%d)s - %(title)s.%(ext)s"

sudo chown -R jellyfin:jellyfin "${path}"