#!/bin/bash

# VARIABLES
dir_home='/home/{username}'
dir_backup='/to/dir'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m'
SLEEP='.5'

# RESTORE FILES
echo && printf "${YELLOW}Restoring bash files" && printf "${NC}" && echo && echo && sleep .5
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.bashrc "${dir_home}"/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.bash_aliases "${dir_home}"/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/systembackup.sh "$dir_home"/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/transferphotos-card.sh "${dir_home}"/
echo && printf "${GREEN}Done restoring the bash files" && printf "${NC}" && echo && echo && sleep .5



echo && printf "${YELLOW}Restoring the fstab file" && printf "${NC}" && echo && echo && sleep .5
if [ ! -f /etc/fstab.bak ]; then
	echo && printf "${YELLOW}Backing up the file" && printf "${NC}" && echo && echo && sleep .5
	sudo cp /etc/fstab /etc/fstab.bak
fi

sudo rsync -aP "${dir_backup}"/etc/fstab /etc/
echo && printf "${GREEN}Done restoring the fstab file" && printf "${NC}" && echo && echo && sleep .5



echo && printf "${YELLOW}Sourcing the bash_aliases file" && printf "${NC}" && echo && echo && sleep ${SLEEP}
source "${dir_home}"/.bash_aliases
echo && printf "${GREEN}Done" && printf "${NC}" && echo && echo && sleep .5



# UNINSTALL
echo && printf "${YELLOW}Uninstalling bloatware" && printf "${NC}" && echo && echo && sleep .5
which parole | grep -o parole > /dev/null &&  sudo pacman -Rcns parole || echo '${BLUE}parole is not installed${NC}'
which firewalld | grep -o firewalld > /dev/null &&  sudo pacman -Rcns firewalld || echo '${BLUE}firewalld is not installed${NC}'
which galculator | grep -o galculator > /dev/null &&  sudo pacman -Rcns galculator || echo '${BLUE}galculator is not installed${NC}'
which ristretto | grep -o ristretto > /dev/null &&  sudo pacman -Rcns ristretto || echo '${BLUE}ristretto is not installed${NC}'
which cmake | grep -o cmake > /dev/null &&  sudo pacman -Rcns cmake || echo '${BLUE}cmake is not installed${NC}'
which eos-quickstart | grep -o eos-quickstart > /dev/null &&  sudo pacman -Rcns eos-quickstart || echo '${BLUE}eos-quickstart is not installed${NC}'
which eos-apps-info | grep -o eos-apps-info > /dev/null &&  sudo pacman -Rcns eos-apps-info || echo '${BLUE}eos-apps-info is not installed${NC}'
which eos-welcome | grep -o eos-welcome > /dev/null &&  sudo pacman -Rcns eos-welcome || echo '${BLUE}eos-welcome is not installed${NC}'
which file-roller | grep -o file-roller > /dev/null &&  sudo pacman -Rcns file-roller || echo '${BLUE}file-roller is not installed${NC}'
echo && printf "${GREEN}Bloatware uninstalled" && printf "${NC}" && echo && echo && sleep .5



# UPDATE
echo && printf "${YELLOW}Updating" && printf "${NC}" && echo && echo && sleep ${SLEEP}
yay -Syu --noconfirm
echo && printf "${GREEN}System is now up-to-date" && printf "${NC}" && echo && echo && sleep .5



# INSTALL
echo && printf "${YELLOW}Installing softwares" && printf "${NC}" && echo && echo && sleep ${SLEEP}
echo && printf "${YELLOW}Starting with installing softwares with yay" && printf "${NC}" && echo && echo && sleep .5
yay -S --noconfirm mullvad-vpn-bin \
vscodium-bin \
qimgv-git \
ttf-victor-mono \
smartgit \
blue-recorder-git \
xfce4-panel-profiles \
hoptodesk \
jotta-cli

echo && printf "${YELLOW}And now installing softwares with pacman" && printf "${NC}" && echo && echo && sleep .5
sudo pacman -S thunderbird \
darktable \
gramps \
steam \
inter-font \
mpv \
obs-studio \
filezilla \
mumble \
speedcrunch \
virtualbox \
ufw \
sshfs \
python-pip \
gtk2 \
ttc-iosevka \
kcolorchooser \
skanlite \
yt-dlp \
papirus-icon-theme \
openssh \
wine \
qmmp \
gimp \
shotcut \
qbittorrent \
inkscape \
lutris \
krita \
cifs-utils \
gajim \
jellyfin-server \
jellyfin-web \
vivaldi \
syncthing \
telegram-desktop \
gparted \
perl-image-exiftool \
npm \
lite-xl \
archlinux-keyring \
xarchiver

echo && printf "${GREEN}Softwares installed" && printf "${NC}" && echo && echo && sleep .5

echo && printf "${YELLOW}Installing Joplin" && printf "${NC}" && echo && echo && sleep .5
wget -O - https://raw.githubusercontent.com/laurent22/joplin/dev/Joplin_install_and_update.sh | bash
echo && printf "${GREEN}Joplin installed" && printf "${NC}" && echo && echo && sleep .5



# CREATE FOLDER
echo && printf "${YELLOW}Creating missing folders" && printf "${NC}" && sleep ${SLEEP}

if [ ! -d "/mnt/Backup" ]; then
	echo && printf "${GREEN}Created /mnt/Backup" && printf "${NC}" && sleep .5
	sudo mkdir /mnt/Backup
else
	echo && printf "${BLUE}/mnt/Backup already exists" && printf "${NC}" && sleep .5
fi

if [ ! -d "/mnt/NAS" ]; then
	echo && printf "${GREEN}Created /mnt/NAS" && printf "${NC}" && sleep .5
	sudo mkdir /mnt/NAS
else
	echo && printf "${BLUE}/mnt/NAS already exists" && printf "${NC}" && sleep .5
fi

if [ ! -d "/mnt/Synology" ]; then
	echo && printf "${GREEN}Created /mnt/Synology" && printf "${NC}" && sleep .5
	sudo mkdir /mnt/Synology
else
	echo && printf "${BLUE}/mnt/Synology already exists" && printf "${NC}" && sleep .5
fi

echo && printf "${GREEN}Done" && printf "${NC}" && echo && echo && sleep .5



# INSTALL GRAPHIC DRIVERS
echo && printf "${YELLOW}Installing graphic card stuff" && printf "${NC}" && echo && echo && sleep ${SLEEP}
install_no nvidia nvidia-settings nvidia-utils lib32-nvidia-utils lib32-opencl-nvidia opencl-nvidia libvdpau libxnvctrl vulkan-icd-loader lib32-vulkan-icd-loader
echo && printf "${GREEN}Done installing graphic card stuff" && printf "${NC}" && echo && echo && sleep .5



# CONFIG
echo && printf "${YELLOW}Configuring the graphic card" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo nvidia-xconfig
sudo mv /etc/X11/xorg.conf /etc/X11/xorg.conf.d/20-nvidia.conf
echo && printf "${GREEN}Done configurating the graphic card" && printf "${NC}" && echo && echo && sleep .5



# STORE DATA
echo && printf "${YELLOW}Restoring backed up files" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/darktable/ "${dir_home}"/.config/darktable/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/mpv/ "${dir_home}"/.config/mpv/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/'Mullvad VPN'/ "${dir_home}"/.config/'Mullvad VPN'/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/qimgv/ "${dir_home}"/.config/qimgv/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/obs-studio/ "${dir_home}"/.config/obs-studio/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/smartgit/ "${dir_home}"/.config/smartgit/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/filezilla/ "${dir_home}"/.config/filezilla/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/GIMP/ "${dir_home}"/.config/GIMP/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/FreeFileSync/ "${dir_home}"/.config/FreeFileSync/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/JOSM/ "${dir_home}"/.config/JOSM/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/Joplin/ "${dir_home}"/.config/Joplin/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/joplin-desktop/ "${dir_home}"/.config/joplin-desktop/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/SpeedCrunch/ "${dir_home}"/.config/SpeedCrunch/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/VSCodium/ "${dir_home}"/.config/VSCodium/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/VirtualBox/ "${dir_home}"/.config/VirtualBox/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/qBittorrent/ "${dir_home}"/.config/qBittorrent/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/lite-xl/ "${dir_home}"/.config/lite-xl/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/qmmp/ "${dir_home}"/.config/qmmp/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/Mumble/ "${dir_home}"/.config/Mumble/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/vivaldi/ "${dir_home}"/.config/vivaldi/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/hoptodesk/ "${dir_home}"/.config/hoptodesk/

sudo rsync -aP "${dir_backup}"/"${dir_home}"/.local/share/gramps/ "${dir_home}"/.local/share/gramps/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.local/share/TelegramDesktop/ "${dir_home}"/.local/share/TelegramDesktop/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.local/share/Steam/ "${dir_home}"/.local/share/Steam/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.local/share/lutris/ "${dir_home}"/.local/share/lutris/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.local/state/syncthing/ "${dir_home}"/.local/state/syncthing/

sudo rsync -aP --delete "${dir_backup}"/"${dir_home}"/.mozilla/firefox/ "${dir_home}"/.mozilla/firefox/
sudo rsync -aP --delete "${dir_backup}"/"${dir_home}"/.thunderbird/ "${dir_home}"/.thunderbird/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.joplin/ "${dir_home}"/.joplin/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.vscode-oss/ "${dir_home}"/.vscode-oss/

sudo rsync -aP "${dir_backup}"/"${dir_home}"/Pictures/Wallpapers/ "${dir_home}"/Pictures/Wallpapers/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/Documents/ "${dir_home}"/Documents/
echo && printf "${GREEN}Done restoring files" && printf "${NC}" && echo && echo && sleep .5



# JELLYFIN
echo && printf "${YELLOW}Configuring Jellyfin" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo rsync -aP "${dir_backup}"/var/lib/jellyfin/ /var/lib/jellyfin/
sudo chown -R jellyfin:jellyfin /var/lib/jellyfin/
sudo chmod -R 777 /var/lib/jellyfin/
sudo systemctl restart jellyfin.service
echo && printf "${GREEN}Done configuring Jellyfin" && printf "${NC}" && echo && echo && sleep .5



# APACHE
echo && printf "${YELLOW}Installing Apache" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo pacman -Sy apache
echo && printf "${GREEN}Done installing Apache" && printf "${NC}" && echo && echo && sleep .5



# MYSQL
echo && printf "${YELLOW}Installing MariaDB" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo pacman -Sy mariadb
sudo mysql_install_db --user=mysql --basedir=/usr --datadir=/var/lib/mysql
sudo systemctl start mariadb.service
sudo mysql_secure_installation
echo && printf "${GREEN}Done installing MariaDB" && printf "${NC}" && echo && echo && sleep .5



# PHP
echo && printf "${YELLOW}Installing PHP" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo pacman -Sy php php-apache php-gd php-fpm php-sqlite
echo && printf "${GREEN}Done installing PHP" && printf "${NC}" && echo && echo && sleep .5



# ENABLE BOOT
echo && printf "${YELLOW}Enabling services for boot" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo systemctl enable mysqld httpd sshd jellyfin syncthing@airikr.service
echo && printf "${GREEN}Done" && printf "${NC}" && echo && echo && sleep .5



# START
echo && printf "${YELLOW}Starting SSH & Syncthing" && printf "${NC}" && echo && echo
sudo systemctl start sshd syncthing@airikr.service
echo && printf "${GREEN}Done" && printf "${NC}" && echo && echo && sleep .5



# COMPOSER
echo && printf "${YELLOW}Installing Composer" && printf "${NC}" && echo && echo && sleep ${SLEEP}
php -r "copy('https://getcomposer.org/installer', 'composer-setup.php');"
php -r "if (hash_file('sha384', 'composer-setup.php') === 'dac665fdc30fdd8ec78b38b9800061b4150413ff2e3b6f88543c636f7cd84f6db9189d43a81e5503cda447da73c7e5b6') { echo 'Installer verified'; } else { echo 'Installer corrupt'; unlink('composer-setup.php'); } echo PHP_EOL;"
php composer-setup.php
php -r "unlink('composer-setup.php');"
sudo mv composer.phar /usr/local/bin/composer
echo && printf "${GREEN}Done installing Composer" && printf "${NC}" && echo && echo && sleep .5



# GEOSPATIAL
#git clone https://github.com/php-geospatial/geospatial.git
#cd geospatial
#phpize
#./configure --enable-geospatial
#make
#sudo make install



# RESTORE WEB SERVER FILES
echo && printf "${YELLOW}Restoring configuration files for the web server" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo rsync -aP "${dir_backup}"/etc/httpd/conf/httpd.conf /etc/httpd/conf/
sudo rsync -aP "${dir_backup}"/etc/httpd/conf/extra/phpmyadmin.conf /etc/httpd/conf/extra/
sudo rsync -aP "${dir_backup}"/etc/php/php.ini /etc/php/
echo && printf "${GREEN}Done restoring configuration files for the web server" && printf "${NC}" && echo && echo && sleep .5

echo && printf "${YELLOW}Restoring website projects" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo rsync -aP "${dir_backup}"/srv/http/ /srv/http/
echo && printf "${GREEN}Done restoring website projects" && printf "${NC}" && echo && echo && sleep .5



# RESTART
echo && printf "${YELLOW}Restarting Apache" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo systemctl restart httpd.service
echo && printf "${GREEN}Done" && printf "${NC}" && echo && echo && sleep .5



# ADDING USER
echo && printf "${YELLOW}Adding vboxusers to the user group" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo usermod -a -G vboxusers $USER
echo && printf "${GREEN}Done. Log out and log back in to enable vboxusers" && printf "${NC}" && echo && echo && sleep .5



# CONFIGURE JOTTA-CLI
echo && printf "${YELLOW}Configuring jotta-cli" && printf "${NC}" && echo && echo && sleep ${SLEEP}
run_jottad
jotta-cli login
jotta-cli sync setup --root /mnt/ExtSSD/JottaSync/
jotta-cli sync start
jotta-cli sync status
jotta-cli add '/home/{username}/'
echo && printf "${YELLOW}Run jotta-cli scan to start the scanning" && printf "${NC}" && echo && echo && sleep .5

echo && printf "${GREEN}All done!" && printf "${NC}"



# Log out and log back in again to enable vboxusers
# Download FreeFileSync at https://freefilesync.org/

# Use the following if root's password is wrong
# sudo mysql
# ALTER USER 'root'@'localhost' IDENTIFIED VIA mysql_native_password USING PASSWORD('password');
# quit

# Connect to MySQL with the root user
# /usr/bin/mariadb -u root -p

# To create a new user and grant all privileges
# CREATE USER 'user'@'localhost' IDENTIFIED BY 'password';
# GRANT ALL PRIVILEGES ON *.* TO 'user'@'localhost';

# To change the username
# RENAME USER 'user'@'localhost' to 'new-user'@'localhost';

# To change the password
# ALTER USER 'user'@'localhost' IDENTIFIED BY 'new-password';
# quit

# sudo nano /etc/X11/xorg.conf.d/20-nvidia.conf
# If anything, install gamemode and lib32-gamemode
# Follow the instructions below NVIDIA Improvements at https://steamcommunity.com/sharedfiles/filedetails/?id=1787799592