#!/bin/bash

# Kolla om till exempel qimgv är installerat eller inte

# VARIABLES
dir_home='/home/airikr'
dir_backup='backup-ssd-dir'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m'
SLEEP='.5'

# COPY > PASTE
echo && printf "${YELLOW}Restoring bash files" && printf "${NC}" && echo && echo && sleep .5
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.bashrc "${dir_home}"/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.bash_aliases "${dir_home}"/
sudo rsync -aP "${dir_backup}"/"$dir_home"/systembackup.sh "$dir_home"/
sudo rsync -aP "${dir_backup}"/"$dir_home"/transferphotos-card.sh "${dir_home}"/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/transferphotos-ext.sh "${dir_home}"/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/transferphotos-ext.sh "${dir_home}"/

echo && printf "${YELLOW}Restoring the fstab file" && printf "${NC}" && echo && echo && sleep .5
sudo cp /etc/fstab /etc/fstab.bak
sudo rsync -aP "${dir_backup}"/etc/fstab /etc/

echo && printf "${YELLOW}Sourcing the bash_aliases file" && printf "${NC}" && echo && echo && sleep ${SLEEP}
source "${dir_home}"/.bash_aliases

# UNINSTALL
echo && printf "${YELLOW}Uninstalling bloatware" && printf "${NC}" && echo && echo && sleep .5
which parole | grep -o parole > /dev/null &&  sudo pacman -Rcns parole || echo '${BLUE}parole is not installed${NC}'
which firewalld | grep -o firewalld > /dev/null &&  sudo pacman -Rcns firewalld || echo '${BLUE}firewalld is not installed${NC}'
which galculator | grep -o galculator > /dev/null &&  sudo pacman -Rcns galculator || echo '${BLUE}galculator is not installed${NC}'
which ristretto | grep -o ristretto > /dev/null &&  sudo pacman -Rcns ristretto || echo '${BLUE}ristretto is not installed${NC}'
which cmake | grep -o cmake > /dev/null &&  sudo pacman -Rcns cmake || echo '${BLUE}cmake is not installed${NC}'
which eos-quickstart | grep -o eos-quickstart > /dev/null &&  sudo pacman -Rcns eos-quickstart || echo '${BLUE}eos-quickstart is not installed${NC}'
which eos-apps-info | grep -o eos-apps-info > /dev/null &&  sudo pacman -Rcns eos-apps-info || echo '${BLUE}eos-apps-info is not installed${NC}'
which welcome | grep -o welcome > /dev/null &&  sudo pacman -Rcns welcome || echo '${BLUE}welcome is not installed${NC}'

# UPDATE
echo && printf "${YELLOW}Updating" && printf "${NC}" && echo && echo && sleep ${SLEEP}
yay -Syu --noconfirm

# INSTALL
echo && printf "${YELLOW}Installing softwares" && printf "${NC}" && echo && echo && sleep ${SLEEP}
yay -S --noconfirm mullvad-vpn-bin vscodium-bin qimgv-git ttf-victor-mono smartgit blue-recorder-git josm-stable xfce4-panel-profiles xfce4-docklike-plugin
sudo pacman -S thunderbird darktable gramps steam inter-font mpv obs-studio filezilla element-desktop mumble speedcrunch virtualbox ufw sshfs python-pip gtk2 ttc-iosevka kcolorchooser skanlite yt-dlp openssh wine qmmp gimp shotcut qbittorrent inkscape gamemode lib32-gamemode krita cifs-utils gajim jellyfin-server jellyfin-web syncthing telegram-desktop perl-image-exiftool npm lite-xl
wget -O - https://raw.githubusercontent.com/laurent22/joplin/dev/Joplin_install_and_update.sh | bash

# CREATE FOLDER
echo && printf "${YELLOW}Creating missing folders" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo mkdir /mnt/Backup
sudo mkdir /mnt/NAS
sudo mkdir /mnt/Synology

# INSTALL GRAPHIC DRIVERS
echo && printf "${YELLOW}Installing graphic cards stuff" && printf "${NC}" && echo && echo && sleep ${SLEEP}
install_no nvidia nvidia-settings nvidia-utils lib32-nvidia-utils lib32-opencl-nvidia opencl-nvidia libvdpau libxnvctrl vulkan-icd-loader lib32-vulkan-icd-loader

# CONFIG
echo && printf "${YELLOW}Configuring the graphic card" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo nvidia-xconfig
sudo mv /etc/X11/xorg.conf /etc/X11/xorg.conf.d/20-nvidia.conf



# COPY > PASTE
echo && printf "${YELLOW}Restoring backed up files" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/darktable/ "${dir_home}"/.config/darktable/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/mpv/ "${dir_home}"/.config/mpv/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/'Mullvad VPN'/ "${dir_home}"/.config/'Mullvad VPN'/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/qimgv/ "${dir_home}"/.config/qimgv/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/obs-studio/ "${dir_home}"/.config/obs-studio/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/smartgit/ "${dir_home}"/.config/smartgit/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/filezilla/ "${dir_home}"/.config/filezilla/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/GIMP/ "${dir_home}"/.config/GIMP/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/FreeFileSync/ "${dir_home}"/.config/FreeFileSync/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/JOSM/ "${dir_home}"/.config/JOSM/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/Joplin/ "${dir_home}"/.config/Joplin/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/joplin-desktop/ "${dir_home}"/.config/joplin-desktop/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/SpeedCrunch/ "${dir_home}"/.config/SpeedCrunch/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/VSCodium/ "${dir_home}"/.config/VSCodium/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/VirtualBox/ "${dir_home}"/.config/VirtualBox/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/qBittorrent/ "${dir_home}"/.config/qBittorrent/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/lite-xl/ "${dir_home}"/.config/lite-xl/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/qmmp/ "${dir_home}"/.config/qmmp/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.config/Mumble/ "${dir_home}"/.config/Mumble/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.mozilla/firefox/ "${dir_home}"/.mozilla/firefox/

sudo rsync -aP "${dir_backup}"/"${dir_home}"/.thunderbird/ "${dir_home}"/.thunderbird/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.joplin/ "${dir_home}"/.joplin/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/.vscode-oss/ "${dir_home}"/.vscode-oss/

sudo rsync -aP "${dir_backup}"/"${dir_home}"/Pictures/Wallpapers/ "${dir_home}"/Pictures/Wallpapers/
sudo rsync -aP "${dir_backup}"/"${dir_home}"/Documents/ "${dir_home}"/Documents/



# JELLYFIN
echo && printf "${YELLOW}Configuring Jellyfin" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo rsync -aP "${dir_backup}"/var/lib/jellyfin/ /var/lib/jellyfin/
sudo chown -R jellyfin:jellyfin /var/lib/jellyfin/
sudo chmod -R 777 /var/lib/jellyfin/
sudo systemctl restart jellyfin.service



# APACHE
echo && printf "${YELLOW}Installing Apache" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo pacman -Sy apache

# MYSQL
echo && printf "${YELLOW}Installing MariaDB" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo pacman -Sy mariadb
sudo mysql_install_db --user=mysql --basedir=/usr --datadir=/var/lib/mysql
sudo systemctl start mariadb.service
sudo mysql_secure_installation

# PHP
echo && printf "${YELLOW}Installing PHP" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo pacman -Sy php php-apache php-gd php-fpm php-sqlite php-pgsql

# ENABLE BOOT
echo && printf "${YELLOW}Enabling services for boot" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo systemctl enable mysqld httpd sshd jellyfin syncthing@airikr.service

# START
echo && printf "${YELLOW}Starting SSH & Syncthing" && printf "${NC}" && echo && echo
sudo systemctl start sshd syncthing@airikr.service

# COMPOSER
echo && printf "${YELLOW}Installing Composer" && printf "${NC}" && echo && echo && sleep ${SLEEP}
php -r "copy('https://getcomposer.org/installer', 'composer-setup.php');"
php -r "if (hash_file('sha384', 'composer-setup.php') === 'dac665fdc30fdd8ec78b38b9800061b4150413ff2e3b6f88543c636f7cd84f6db9189d43a81e5503cda447da73c7e5b6') { echo 'Installer verified'; } else { echo 'Installer corrupt'; unlink('composer-setup.php'); } echo PHP_EOL;"
php composer-setup.php
php -r "unlink('composer-setup.php');"
sudo mv composer.phar /usr/local/bin/composer

# GEOSPATIAL
git clone https://github.com/php-geospatial/geospatial.git
cd geospatial
phpize
./configure --enable-geospatial
make
sudo make install

# COPY > PASTE
echo && printf "${YELLOW}Restoring configuration files for web server" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo rsync -aP "${dir_backup}"/etc/httpd/conf/httpd.conf /etc/httpd/conf/
sudo rsync -aP "${dir_backup}"/etc/httpd/conf/extra/phpmyadmin.conf /etc/httpd/conf/extra/
sudo rsync -aP "${dir_backup}"/etc/php/php.ini /etc/php/

echo && printf "${YELLOW}Restoring website projects" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo rsync -aP "${dir_backup}"/srv/http/ /srv/http/

# RESTART
echo && printf "${YELLOW}Restarting Apache" && printf "${NC}" && echo && echo && sleep ${SLEEP}
sudo systemctl restart httpd.service

# ADDING USER
sudo usermod -a -G vboxusers $USER

# INSTRUCTIONS
printf "${BLUE}"
echo
echo '--------'
echo
echo 'Use the following if root's password is wrong'
echo 'sudo mysql'
echo 'ALTER USER 'root'@'localhost' IDENTIFIED VIA mysql_native_password USING PASSWORD('password');'
echo 'quit'
echo
echo '--------'
echo
echo 'Connect to MySQL with the root user'
echo '/usr/bin/mariadb -u root -p'
echo
echo 'To create a new user and grant all privileges'
echo 'CREATE USER 'user'@'localhost' IDENTIFIED BY 'password';'
echo 'GRANT ALL PRIVILEGES ON *.* TO 'user'@'localhost';'
echo
echo 'To change the username'
echo 'RENAME USER 'user'@'localhost' to 'new-user'@'localhost';'
echo
echo 'To change the password'
echo 'ALTER USER 'user'@'localhost' IDENTIFIED BY 'new-password';'
echo
echo 'quit'
echo
echo '--------'
echo
echo 'sudo nano /etc/X11/xorg.conf.d/20-nvidia.conf'
echo 'Follow the instructions below NVIDIA Improvements at https://steamcommunity.com/sharedfiles/filedetails/?id=1787799592'
echo
echo 'Download FreeFileSync at https://freefilesync.org/'
echo
echo 'Log out and log back in again to enable vboxusers'
printf "${NC}"